/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.inventorysorter;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import cpw.mods.inventorysorter.InventorySorter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import net.jodah.typetools.TypeResolver;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.loading.StringUtils;

public class InventorySorterCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder invsorterBuilder = (LiteralArgumentBuilder)Commands.m_82127_((String)"invsorter").requires(cs -> cs.m_6761_(1));
        Stream.of(CommandAction.values()).forEach(a -> invsorterBuilder.then(a.getCommand()));
        invsorterBuilder.executes(InventorySorterCommand::help);
        dispatcher.register(invsorterBuilder);
    }

    private static int help(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("inventorysorter.commands.inventorysorter.usage"), false);
        return 0;
    }

    private static enum CommandAction {
        BLADD(InventorySorter::blackListAdd, 1, Arguments.CONTAINER),
        BLREMOVE(InventorySorter::blackListRemove, 4, Arguments.BLACKLISTED),
        SHOWLAST(InventorySorter::showLast, 1, new TypedArgumentHandler[0]),
        LIST(InventorySorter::showBlacklist, 1, new TypedArgumentHandler[0]);

        private final int permissionLevel;
        private final ToIntFunction<CommandContext<CommandSourceStack>> action;
        private final List<TypedArgumentHandler<?>> argumentSupplier;

        private CommandAction(ToIntFunction<CommandContext<CommandSourceStack>> action, int permissionLevel, TypedArgumentHandler<?> ... argumentSupplier) {
            this.action = action;
            this.permissionLevel = permissionLevel;
            this.argumentSupplier = Arrays.asList(argumentSupplier);
        }

        private void addArguments(LiteralArgumentBuilder<CommandSourceStack> builder) {
            Optional<ArgumentBuilder> argBuilder = this.argumentSupplier.stream().map(TypedArgumentHandler::build).reduce(ArgumentBuilder::then);
            argBuilder.ifPresentOrElse(b -> builder.then(b.executes(this.action::applyAsInt)), () -> builder.executes(this.action::applyAsInt));
        }

        public LiteralArgumentBuilder<CommandSourceStack> getCommand() {
            LiteralArgumentBuilder base = (LiteralArgumentBuilder)Commands.m_82127_((String)StringUtils.toLowerCase((String)this.name())).requires(cs -> cs.m_6761_(this.permissionLevel));
            this.addArguments((LiteralArgumentBuilder<CommandSourceStack>)base);
            return base;
        }
    }

    public static class ContainerClassArgument
    implements ArgumentType<ResourceLocation> {
        private static final List<String> EXAMPLES = Collections.singletonList("minecraft:chest");
        private final Supplier<Stream<String>> containerSuggestions;

        ContainerClassArgument(Supplier<Stream<String>> suggestions) {
            this.containerSuggestions = suggestions;
        }

        public ResourceLocation parse(StringReader reader) throws CommandSyntaxException {
            return ResourceLocation.m_135818_((StringReader)reader);
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            return SharedSuggestionProvider.m_82981_(this.containerSuggestions.get(), (SuggestionsBuilder)builder);
        }

        public Collection<String> getExamples() {
            return EXAMPLES;
        }
    }

    public static class TypedArgumentHandler<T> {
        private final String argName;
        private final ArgumentType<T> argumentType;
        private final Class<T> clazz;

        TypedArgumentHandler(String argName, Supplier<? extends ArgumentType<T>> argumentType) {
            this.argName = argName;
            this.argumentType = argumentType.get();
            Class[] classes = TypeResolver.resolveRawArguments(ArgumentType.class, this.argumentType.getClass());
            this.clazz = classes[0];
        }

        public static <A> TypedArgumentHandler<A> of(String argumentName, Supplier<? extends ArgumentType<A>> supplier) {
            return new TypedArgumentHandler(argumentName, supplier);
        }

        public RequiredArgumentBuilder<CommandSourceStack, T> build() {
            return Commands.m_82129_((String)this.argName, this.argumentType);
        }

        public T get(CommandContext<CommandSourceStack> context) {
            return (T)context.getArgument(this.argName, this.clazz);
        }
    }

    public static class Arguments {
        static final TypedArgumentHandler<ResourceLocation> CONTAINER = new TypedArgumentHandler("container", () -> new ContainerClassArgument(InventorySorter::listContainers));
        static final TypedArgumentHandler<ResourceLocation> BLACKLISTED = new TypedArgumentHandler("blacklisted", () -> new ContainerClassArgument(InventorySorter::listBlacklist));
    }
}

